/*
       Licensed to the Apache Software Foundation (ASF) under one
       or more contributor license agreements.  See the NOTICE file
       distributed with this work for additional information
       regarding copyright ownership.  The ASF licenses this file
       to you under the Apache License, Version 2.0 (the
       "License"); you may not use this file except in compliance
       with the License.  You may obtain a copy of the License at

         http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing,
       software distributed under the License is distributed on an
       "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
       KIND, either express or implied.  See the License for the
       specific language governing permissions and limitations
       under the License.
*/

package org.apache.cordova.unittests;

import android.content.Intent;
import android.graphics.Color;
import android.support.test.rule.ActivityTestRule;
import android.support.test.runner.AndroidJUnit4;
import android.view.View;
import android.widget.LinearLayout;

import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.engine.SystemWebView;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.assertFalse;
import static junit.framework.Assert.assertNotNull;
import static junit.framework.Assert.assertNotSame;
import static junit.framework.Assert.assertTrue;

/**
 * The purpose of this test is to test the default application that is generated by Cordova itself
 *
 */
@RunWith(AndroidJUnit4.class)
public class StandardActivityTest {

    private static final String FALSE_URI = "http://www.google.com";

    // Don't launch the activity, we're going to send it intents
    @Rule
    public ActivityTestRule mActivityRule = new ActivityTestRule<>(
            StandardActivity.class, true, false);

    @Before
    public void launchApplicationWithIntent() {
        Intent intent = new Intent();
        intent.putExtra("startUrl", FALSE_URI);
        intent.putExtra("backgroundcolor", "#0000ff");
        mActivityRule.launchActivity(intent);
    }


    @Test
    public void webViewCheck() {
        StandardActivity activity = (StandardActivity) mActivityRule.getActivity();
        //Fish the webview out of the mostly locked down Activity using the Android SDK
        View view = activity.getWindow().getCurrentFocus();
        assertEquals(SystemWebView.class, view.getClass());
    }

    @Test
    public void startUriIntentCheck() {
        StandardActivity activity = (StandardActivity) mActivityRule.getActivity();
        final SystemWebView webView = (SystemWebView) activity.getWindow().getCurrentFocus();
        try {
            mActivityRule.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    String uri = webView.getUrl();
                    assertFalse(uri.equals(FALSE_URI));
                }
            });
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Test
    public void checkBackgroundIntentCheck() {
        StandardActivity activity = (StandardActivity) mActivityRule.getActivity();
        final SystemWebView webView = (SystemWebView) activity.getWindow().getCurrentFocus();
        CordovaWebView webInterface = webView.getCordovaWebView();
        CordovaPreferences prefs = webInterface.getPreferences();
        assertFalse(prefs.getInteger("backgroundcolor", Color.BLACK) == Color.GREEN);
    }

}
